package com.mmc.pms.entity;

import com.mmc.pms.model.sale.dto.IndustrySpecDTO;
import com.mmc.pms.model.sale.dto.MallIndustrySpecDTO;
import com.mmc.pms.model.sale.vo.IndustrySpecVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small @Date 2023/5/16 15:35 @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class IndustrySpecDO implements Serializable {
    private static final long serialVersionUID = 8701065950780976397L;
    private Integer id;
    private Integer industrySkuId;
    private String specName;
    private String specImage;
    private Date createTime;
    private Date updateTime;
    private Integer deleted;

    private String solutionName;

    public IndustrySpecDO(IndustrySpecVO param) {
        this.id = param.getId();
        this.industrySkuId = param.getIndustrySkuId();
        this.specName = param.getSpecName();
        this.specImage = param.getSpecImage();
    }

    public IndustrySpecDTO buildIndustrySpecDTO() {
        return IndustrySpecDTO.builder()
                .id(this.id)
                .industrySkuId(this.industrySkuId)
                .specImage(this.specImage)
                .specName(this.specName)
                .createTime(this.createTime)
                .build();
    }

    public MallIndustrySpecDTO buildMallIndustrySpecDTO() {
        return MallIndustrySpecDTO.builder()
                .industrySpecId(this.id)
                .industrySkuId(this.industrySkuId)
                .specImage(this.specImage)
                .specName(this.specName)
                .build();
    }
}
