package com.mmc.pms.entity;

import com.mmc.pms.model.categories.dto.AllCategoryDTO;
import com.mmc.pms.model.categories.vo.DirectoryInfoVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 目录管理表(Directory)实体类
 *
 * @author makejava
 * @since 2023-05-24 14:58:31
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class DirectoryDO implements Serializable {
  private static final long serialVersionUID = 713939370607409336L;
  /** 主键id */
  private Integer id;
  /** 目录名称 */
  private String directoryName;
  /** 其他目录关联id */
  private Integer pid;
  /** 类型：（0：通用目录 1：作业服务目录 2：设备目录 3：飞手目录 4：商城目录） */
  private Integer type;
  /** 创建时间 */
  private Date createTime;
  /** 修改时间 */
  private Date updateTime;
  /** 是否删除 */
  private Integer deleted;

  private String show;

  private String relevanceName;

  public DirectoryDO(DirectoryInfoVO param) {
    if (CollectionUtils.isNotEmpty(param.getShow())) {
      String show = param.getShow().stream().map(Object::toString).collect(Collectors.joining(","));
      this.show = show;
    }
    this.id = param.getId();
    this.directoryName = param.getDirectoryName();
    this.type = param.getType();
  }

  public DirectoryInfoVO buildDirectoryInfoVO() {
    List<Integer> show = null;
    if (!StringUtils.isBlank(this.show)) {
      String[] split = this.show.split(",");
      show = Arrays.stream(split).map(Integer::parseInt).collect(Collectors.toList());
    }

    return DirectoryInfoVO.builder()
        .id(id)
        .directoryName(directoryName)
        .show(show)
        .type(type)
        .build();
  }

  public AllCategoryDTO buildAllCategoryDTO() {
    return AllCategoryDTO.builder().directoryId(id).name(directoryName).build();
  }
}
