package com.mmc.pms.entity;

import com.mmc.pms.model.sale.dto.BrandInfoDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;


/**
 * @Author LW
 * @date 2022/6/20 16:33
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class BrandInfoDO implements Serializable {

    private static final long serialVersionUID = 2832084701380349536L;
    private Integer id;
    private String brandName;
    private Date createTime;
    private Date updateTime;
    private Integer delete;

    public BrandInfoDO(String brandName) {
        this.brandName = brandName;
    }

    public BrandInfoDTO buildBrandInfoDTO() {
        return BrandInfoDTO.builder().id(id).brandName(brandName).createTime(createTime).build();
    }
}
