package com.mmc.pms.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.mmc.pms.auth.dto.CompanyInfoDTO;
import com.mmc.pms.auth.dto.CompanyInfoVO;
import com.mmc.pms.common.ResultBody;
import com.mmc.pms.constant.DateConstant;
import com.mmc.pms.dao.BackstageTaskServiceDao;
import com.mmc.pms.dao.CategoriesDao;
import com.mmc.pms.entity.Categories;
import com.mmc.pms.entity.InspComtDO;
import com.mmc.pms.entity.ServiceDO;
import com.mmc.pms.feign.UserAppApi;
import com.mmc.pms.model.inspection.dto.CompanyInspectionDTO;
import com.mmc.pms.model.qo.CompanyInfoQO;
import com.mmc.pms.model.qo.ServiceQO;
import com.mmc.pms.model.work.dto.ServiceDTO;
import com.mmc.pms.model.work.dto.WorkServiceDTO;
import com.mmc.pms.model.work.vo.ServiceVO;
import com.mmc.pms.model.work.vo.UpAndDownServiceVO;
import com.mmc.pms.page.PageResult;
import com.mmc.pms.service.BackstageTaskService;
import com.mmc.pms.service.InspComtService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author LW
 *
 * @date 2023/6/8 9:59 概要：
 */
@Service
@Slf4j
public class BackstageTaskServiceImpl implements BackstageTaskService {

  @Autowired private BackstageTaskServiceDao backstageTaskServiceDao;

  @Autowired private CategoriesDao categoriesDao;

  @Autowired private UserAppApi userAppApi;

  @Autowired private InspComtService inspComtService;

  @Autowired private RedisTemplate redisTemplate;

  @Override
  public ResultBody addWorkService(ServiceVO param, Integer userAccountId) {
    ServiceDO serviceDO = new ServiceDO(param, userAccountId);
    Integer insert = backstageTaskServiceDao.insert(serviceDO);
    backstageTaskServiceDao.exchangeSort(serviceDO.getId(),serviceDO.getId());
    return ResultBody.success();
  }

  @Override
  public ResultBody updateById(ServiceVO param) {
    ServiceDO serviceDO = new ServiceDO(param);
    backstageTaskServiceDao.update(serviceDO);
    return ResultBody.success();
  }

  @Override
  public ResultBody deleteByIds(List<Integer> ids) {
    if (!CollectionUtils.isEmpty(ids)) {
      backstageTaskServiceDao.deleteByIds(ids);
    }
    return ResultBody.success();
  }

  @Override
  public ResultBody<ServiceDTO> queryById(Integer id, HttpServletRequest request) {
    ServiceDO serviceDO = backstageTaskServiceDao.queryById(id);
//    String token =
//        userAppApi.getCompanyInfoById(serviceDO.getCompanyId(), request.getHeader("token"));
//    JSONObject jsonObject = JSONObject.parseObject(token);
//    CompanyInfoDTO companyInfoDTO =
//        JSON.parseObject(
//            String.valueOf((JSONObject) jsonObject.get("result")), CompanyInfoDTO.class);
    String companyName = null;
    ResultBody<CompanyInfoVO> res = userAppApi.getCompanyInfoById(id, request.getHeader("token"));
    if (res.getResult() != null) {
      companyName = res.getResult().getCompanyName();
    }
    ServiceDTO serviceDTO = new ServiceDTO(serviceDO, companyName);
    Map<Integer, String> categoriesNameMap =
        getCategoriesNameByIds(
            Arrays.asList(serviceDTO.getApplicationId(), serviceDTO.getIndustryId()));
    if (!CollectionUtils.isEmpty(categoriesNameMap)) {
      serviceDTO.setApplicationName(categoriesNameMap.get(serviceDTO.getApplicationId()));
      serviceDTO.setIndustryName(categoriesNameMap.get(serviceDTO.getIndustryId()));
    }
    List<InspComtDO> inspComtList = RandomGetInspComt(id, 20, 200);
    serviceDTO.setInspComtList(inspComtList);
    serviceDTO.setInspComtAmount(inspComtList.size());
    return ResultBody.success(serviceDTO);
  }

  private Map<Integer, String> getCategoriesNameByIds(List<Integer> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return new HashMap<>();
    }
    Set<Integer> idSet = new HashSet<>();
    for (Integer id : ids) {
      idSet.add(id);
    }
    List<Categories> categories = categoriesDao.getCategoriesListByIds(idSet);
    if (CollectionUtils.isEmpty(categories)) {
      return new HashMap<>();
    }
    return categories.stream()
        .collect(Collectors.toMap(Categories::getId, d -> d.getName(), (k1, k2) -> k1));
  }

  @Override
  public PageResult queryServiceManagerList(
      ServiceQO param, Integer userAccountId, CompanyInfoVO companyInfoVO) {
    param.setCompanyId(companyInfoVO.getId());
    param.setCompanyType(companyInfoVO.getCompanyType());
    int count = backstageTaskServiceDao.count(param);
    if (count == 0) {
      return PageResult.buildPage(param.getPageNo(), param.getPageSize(), count);
    }
    Integer pageNo = param.getPageNo();
    param.buildCurrentPage();
    List<ServiceDO> services = backstageTaskServiceDao.queryAllByLimit(param);
    List<ServiceDTO> pageList = setApplicationNameAndIndustryName(services);
    return PageResult.buildPage(pageNo, param.getPageSize(), count, pageList);
  }

  private List<ServiceDTO> setApplicationNameAndIndustryName(List<ServiceDO> services) {
    List<Integer> list = new ArrayList<>();
    for (ServiceDO service : services) {
      list.add(service.getApplicationId());
      list.add(service.getIndustryId());
    }
    Map<Integer, String> categoriesNameMap = getCategoriesNameByIds(list);
    List<ServiceDTO> pageList =
        services.stream()
            .map(
                d -> {
                  ServiceDTO serviceDTO = new ServiceDTO(d);
                  serviceDTO.setApplicationName(categoriesNameMap.get(d.getApplicationId()));
                  serviceDTO.setIndustryName(categoriesNameMap.get(d.getIndustryId()));
                  return serviceDTO;
                })
            .collect(Collectors.toList());
    return pageList;
  }

  @Override
  @Transactional
  public PageResult queryWorkServiceList(ServiceQO param, HttpServletRequest request) {
    Integer pageNo = param.getPageNo();
    param.buildCurrentPage();
    List<Integer> userIds = null;
    Integer provinceCode = param.getProvinceId();
    if (provinceCode != null) {
      userIds = userAppApi.feignListUserAccountIds(provinceCode, null, null, null);
      if (userIds == null || userIds.size() == 0) {
        userIds = Arrays.asList(-1);
      }
    }
    List<Integer> categoriesIds = param.getCategoryId();
    int count = backstageTaskServiceDao.conditionCount(param, categoriesIds, userIds);
    if (count == 0) {
      return PageResult.buildPage(param.getPageNo(), param.getPageSize(), count);
    }
    List<ServiceDO> pageList =
        backstageTaskServiceDao.queryPageByLimit(param, categoriesIds, userIds);

    List<WorkServiceDTO> workServiceDTOList = getWorkServiceDTOS(pageList, request);
    return PageResult.buildPage(pageNo, param.getPageSize(), count, workServiceDTOList);
  }

  @Override
  public List<ServiceDTO> feignQueryWorkServiceListById(List<Integer> ids) {
    return backstageTaskServiceDao.QueryWorkServiceListById(ids);
  }

  @Override
  public ResultBody batchUpAndDownWorkService(UpAndDownServiceVO param) {
    if (!CollectionUtils.isEmpty(param.getIds())) {
      backstageTaskServiceDao.batchUpAndDownWorkService(param);
    }
    return ResultBody.success();
  }

  @Override
  public Integer getWorkServiceCountByCategoriesId(List<Integer> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return 0;
    }
    return backstageTaskServiceDao.getWorkServiceCountByCategoriesId(ids);
  }

  @Override
  public ResultBody queryByIdCount(Integer companyId) {
    return ResultBody.success(backstageTaskServiceDao.queryByIdCount(companyId));
  }

  @Transactional
  @Override
  public ResultBody exchange(List<ServiceVO> list) {
    Integer sort = list.get(0).getSort();
    ServiceDO serviceDO = new ServiceDO();
    serviceDO.setId(list.get(0).getId());
    serviceDO.setSort(list.get(1).getSort());
    backstageTaskServiceDao.exchange(serviceDO);

    ServiceDO serviceDO1 = new ServiceDO();
    serviceDO1.setId(list.get(1).getId());
    serviceDO1.setSort(sort);
    backstageTaskServiceDao.exchange(serviceDO1);
    return ResultBody.success();
  }

  private List<WorkServiceDTO> getWorkServiceDTOS(List<ServiceDO> pageList,HttpServletRequest request) {
    List<CompanyInfoVO> companyInfoList = userAppApi.listCompanyPage(new CompanyInfoQO(1, 100000), request.getHeader("token"));
    String companyName = "";
    List<WorkServiceDTO> workServiceDTOList = new ArrayList<>();
    for (ServiceDO item : pageList) {
      for (CompanyInfoVO companyInfoVO : companyInfoList) {
        if (item.getCompanyId().equals(companyInfoVO.getId())){
          companyName=companyInfoVO.getCompanyName();
          break;
        }
      }
      List<InspComtDO> inspComtDOS = generateComments(item);
      WorkServiceDTO workServiceDTO =
              WorkServiceDTO.builder()
                      .id(item.getId())
                      .serviceName(item.getServiceName())
                      .companyId(item.getCompanyId())
                      .companyName(companyName)
                      .sort(item.getSort())
                      .coverPlan(item.getCoverPlan())
                      .serviceIntroduction(item.getServiceIntroduction())
                      .video(item.getVideo())
                      .shareCard(item.getShareCard())
                      .inspComtList(inspComtDOS)
                      .inspComtAmount(inspComtDOS.size())
                      .build();
      workServiceDTOList.add(workServiceDTO);
    }
    return workServiceDTOList;
  }

  /**
   * 生成评论
   *
   * @param item
   * @return
   */
  private List<InspComtDO> generateComments(ServiceDO item) {
    Date newServiceHours = null;
    try {
      newServiceHours = DateUtils.parseDate("2023-06-26 23:59:59", DateConstant.YYYYMMDDHHMMSS);
    } catch (ParseException e) {
      e.printStackTrace();
    }
    List<InspComtDO> inspComtDOS;
    // 在这个时间创建的服务信息属于新服务，生成评论的数量在3-5个之间；旧服务则生成20-200个之间
    if (item.getCreateTime().after(newServiceHours)) {
      inspComtDOS = RandomGetInspComt(item.getId(), 3, 5);
    } else {
      inspComtDOS = RandomGetInspComt(item.getId(), 20, 200);
    }
    return inspComtDOS;
  }

  /** 根据id随机获取N条的评论 */
  private List<InspComtDO> RandomGetInspComt(Integer id, Integer min, Integer max) {
    String listStr = (String) redisTemplate.opsForValue().get(id);
    List<InspComtDO> inspComtRandomList = null;
    if (StringUtils.isNotBlank(listStr)) {
      inspComtRandomList = JSONArray.parseArray(listStr, InspComtDO.class);
    } else {
      inspComtRandomList = inspComtService.randomGetInspComtList(RandomUtils.nextInt(min, max));
      String toJSONString = JSONObject.toJSONString(inspComtRandomList);
      redisTemplate.opsForValue().set(id, toJSONString);
    }
    return inspComtRandomList;
  }
}
