package com.mmc.pms.model.work.vo;

import com.mmc.pms.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class UpAndDownServiceVO implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id集合")
    @Size(min = 1,message = "修改时id集合不能为空",groups = Update.class)
    private List<Integer> ids;

    @ApiModelProperty(value = "展示状态,0为上架，1下架", example = "0")
    @NotNull(message = "修改时展示状态不能为空",groups = Update.class)
    private Integer displayState;
}
