package com.mmc.pms.model.mall;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * @Author LW
 * @date 2023/7/24 20:26
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class GoodsSpecValuesVO {
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "规格id", example = "1")
    private Integer goodsSpecId;
    @ApiModelProperty(value = "选项名称", example = "规格值名称", required = true)
    private String specValueName;
    @ApiModelProperty(value = "料号", example = "料号", required = true)
    private String partNo;
    @ApiModelProperty(value = "规格值图片url", example = "1.jpg", required = true)
    private String specValueImage;
    @ApiModelProperty(value = "是否展示销售价格 0：否 1：是", example = "1", required = true)
    private Integer showPrice;
    @ApiModelProperty(value = "库存数量", example = "100")
    private Integer stock;
    @ApiModelProperty(value = "销售价格", example = "100.00", required = true)
    private BigDecimal salePrice;
    @ApiModelProperty(value = "渠道价格", example = "50.00")
    private BigDecimal channelPrice;
}
