package com.mmc.pms.model.inspection.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author: zj
 * @Date: 2023/8/4 16:37
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class InspectionVO implements Serializable {
    private static final long serialVersionUID = 3417959015512957324L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "服务编号")
    private String inspectionNo;
    @ApiModelProperty(value = "服务名称")
    private String inspectionName;
    @ApiModelProperty(value = "行业类型id")
    private Integer industryTypeId;
    @ApiModelProperty(value = "服务图标")
    private String inspectionImg;
    @ApiModelProperty(value = "服务描述")
    private String inspectionDescription;
    @ApiModelProperty(value = "销售状态，0停售，1在售")
    private Integer saleState;
    @ApiModelProperty(value = "案例图")
    private String caseImg;
    @ApiModelProperty(value = "案例视频")
    private String caseVideo;
}
