package com.mmc.pms.entity.lease;

import com.mmc.pms.model.mall.SpecAttrVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 规格属性表(LeaseSpecAttrDO)实体类
 *
 * @author makejava
 * @since 2023-08-11 14:56:29
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class LeaseSpecAttrDO implements Serializable {
    private static final long serialVersionUID = -71136469129605718L;

    private Integer id;
    /**
     * 商品id
     */
    private Integer mallGoodsId;
    /**
     * 规格名称
     */
    private String specName;

    private Date createTime;

    private Date updateTime;

    private List<LeaseSpecAttrValueDO> leaseSpecAttrValues;

    public SpecAttrVO buildSpecAttrVO() {
        return SpecAttrVO.builder().id(id).specName(specName)
                .specValuesList(CollectionUtils.isEmpty(leaseSpecAttrValues) ? null
                        : this.leaseSpecAttrValues.stream().map(LeaseSpecAttrValueDO::buildSpecAttr).collect(Collectors.toList())).build();
    }
}

