package com.mmc.pms.entity;

import com.mmc.pms.model.order.dto.OrderGoodsIndstProdListDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * author:zhenjie
 * Date:2022/10/20
 * time:16:57
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MallGoodsProductDO implements Serializable {
    private static final long serialVersionUID = -8801235084545192790L;
    @ApiModelProperty(value = "行业规格id")
    private Integer industrySpecId;
    @ApiModelProperty(value = "产品规格id")
    private Integer productSpecId;
    @ApiModelProperty(value = "产品规格名称")
    private String specName;
    @ApiModelProperty(value = "产品规格图片")
    private String prodSkuSpecImage;
    @ApiModelProperty(value = "料号")
    private String partNo;
    @ApiModelProperty(value = "版本描述")
    private String versionDesc;
    @ApiModelProperty(value = "商品产品类型名称")
    private String goodsTypeName;
    @ApiModelProperty(value = "产品名称")
    private String productName;
    @ApiModelProperty(value = "型号")
    private String model;
    @ApiModelProperty(value = "品牌")
    private String productBrand;

    public OrderGoodsIndstProdListDTO buildOrderGoodsIndstProdListDTO() {
        return OrderGoodsIndstProdListDTO.builder().productSpecId(this.productSpecId).prodSkuSpecName(this.specName).prodSkuSpecImage(this.prodSkuSpecImage)
                .partNo(this.partNo).versionDesc(this.versionDesc).goodsTypeName(this.goodsTypeName).productName(this.productName).model(this.model).productBrand(this.productBrand).build();
    }

}
