package com.mmc.pms.entity;

import com.mmc.pms.model.order.dto.OrderGoodsIndstDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * author:zhenjie
 * Date:2022/10/20
 * time:16:50
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MallGoodsInfoSimpleDO implements Serializable {
    private static final long serialVersionUID = -9183566814152128414L;
    @ApiModelProperty(value = "商品id")
    private Integer id;
    @ApiModelProperty(value = "商品所属类型")
    private Integer directoryId;
    @ApiModelProperty(value = "商品编号")
    private String goodsNo;
    @ApiModelProperty(value = "商品名称")
    private String goodsName;
    @ApiModelProperty(value = "商品主图")
    private String mainImg;
    @ApiModelProperty(value = "状态 0:下架 1:上架")
    private Integer shelfStatus;
    @ApiModelProperty(value = "是否删除")
    private Integer deleted;
    @ApiModelProperty(value = "商品规格信息")
    private List<MallGoodsSpecSimpleDO> mallGoodsSpecSimpleDOS;

    public OrderGoodsIndstDTO buildOrderGoodsIndstDTO() {
        return OrderGoodsIndstDTO.builder().goodsInfoId(this.id).goodsName(this.goodsName).directoryId(this.directoryId).goodsNo(this.goodsNo).mainImg(this.mainImg).valid(this.deleted.equals(0) && this.shelfStatus.equals(1) ? true : false)
                .orderGoodsIndstDetailDTOS(mallGoodsSpecSimpleDOS == null ? null : this.mallGoodsSpecSimpleDOS.stream().map(d -> d.buildOrderGoodsIndstDetailDTO()).collect(Collectors.toList())).build();
    }
}
