package com.mmc.pms.entity;

import com.mmc.pms.model.sale.dto.ProductInventoryVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small @Date 2023/5/16 15:41 @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class IndustryProductInventoryDO implements Serializable {
    private static final long serialVersionUID = -3586673158091288317L;
    private Integer id;
    private Integer industrySpecId;
    private Integer productSkuId;
    private Integer selected;
    private Integer deleted;
    private Date createTime;
    private Date updateTime;

    public IndustryProductInventoryDO(ProductInventoryVO d) {
        this.productSkuId = d.getProductSku().getId();
        this.selected = d.getSelect();
    }
}
