package com.mmc.pms.entity;

import com.mmc.pms.model.sale.dto.AppGoodsInfoDTO;
import com.mmc.pms.model.sale.dto.GoodsInfoListDTO;
import com.mmc.pms.model.categories.vo.CategoryParamAndValueVO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author small @Date 2023/5/16 13:33 @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
public class GoodsInfoDO implements Serializable {
    private static final long serialVersionUID = -1329342381196659417L;
    private Integer id;
    private Integer pid;
    private String goodsNo;
    private String goodsName;
    private Integer masterTypeId;
    private Integer slaveTypeId;
    private Integer shelfStatus;
    private Integer skuNum;
    private Integer deleted;
    private Date createTime;
    private Date updateTime;
    private Integer goodsAttr;
    private String ecoLabel;
    private Integer goodsCategoryId;
    private Integer repoId;
    private Integer shareFlyServiceId;
    private Integer goodsType;
    private Integer sort;
    private Integer showCode;
    private Integer standardProduct;
    private String tag;

    /**
     * 辅助字段-start
     */
    private String videoUrl;

    private Integer goodsVideoId;
    private String goodsDesc;
    private GoodsVideoDO goodsVideoDO;
    private String mainImg; // 主图
    private GoodsTypeDO goodsMasterType;
    private GoodsTypeDO goodsSlaveType;
    private String remark; // 底部备注
    private Integer sortTypeId;
    private List<CategoryParamAndValueVO> paramAndValue;
    private GoodsConfigExportDO goodsConfigExport; // 功能清单
    private Integer buyNum; // 购买数量
    private String directoryName;
    private Integer isCoupons;

    public GoodsInfoListDTO buildGoodsInfoListDTO() {
        return GoodsInfoListDTO.builder()
                .id(this.id)
                .goodsName(this.goodsName)
                .status(this.shelfStatus)
                .createTime(this.createTime)
                .imgUrl(this.mainImg)
                .directoryId(this.sortTypeId)
                .directoryName(this.directoryName)
                .goodsDesc(this.goodsDesc)
                .goodsOneLevelTypeName(this.goodsMasterType.getTypeName())
                .goodsTwoLevelTypeName(this.goodsSlaveType.getTypeName())
                .isCoupons(this.isCoupons)
                .build();
    }

    public AppGoodsInfoDTO buildAppGoodsInfoDTO() {
        return AppGoodsInfoDTO.builder()
                .id(this.id)
                .goodsName(this.goodsName)
                .mainImg(this.mainImg)
                .goodsDesc(this.goodsDesc)
                .shelfStatus(this.shelfStatus)
                .goodsAttr(this.goodsAttr)
                .ecoLabel(this.tag)
                .showCode(this.showCode)
                .sort(this.sort)
                .build();
    }
}
