package com.mmc.pms.controller.category;

import com.mmc.pms.common.Page;
import com.mmc.pms.common.ResultBody;
import com.mmc.pms.model.category.dto.CategoryPrimaryDTO;
import com.mmc.pms.model.category.dto.CategorySubDTO;
import com.mmc.pms.model.category.qo.CategoryQO;
import com.mmc.pms.model.category.vo.CategoryPrimaryVO;
import com.mmc.pms.model.category.vo.CategorySubVO;
import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.group.Others;
import com.mmc.pms.model.group.Update;
import com.mmc.pms.service.category.CategoryService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @Author small
 * @Date 2023/7/20 16:17
 * @Version 1.0
 * <p>
 * 新版本分类管理
 */
@RestController
@RequestMapping("/category")
@Api(tags = {"后台-新版-分类管理"})
public class CategoryController {

    @Autowired
    private CategoryService categoryService;


    @ApiOperation(value = "一级分类————新增")
    @PostMapping("/addPrimaryCategory")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody addPrimaryCategory(HttpServletRequest request, @RequestBody @Validated(value = {Create.class}) CategoryPrimaryVO primaryVO) {
        return categoryService.addPrimaryCategory(primaryVO);
    }


    @ApiOperation(value = "一级分类————编辑")
    @PostMapping("/updatePrimaryCategory")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody updatePrimaryCategory(HttpServletRequest request, @RequestBody @Validated(value = {Update.class}) CategoryPrimaryVO primaryVO) {
        return categoryService.updatePrimaryCategory(primaryVO);
    }


    @ApiOperation(value = "一级分类————删除")
    @GetMapping("/deletePrimaryCategory")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody deletePrimaryCategory(HttpServletRequest request, @RequestParam(value = "id", required = true) Integer id) {
        return categoryService.deletePrimaryCategory(id);
    }

    @ApiOperation(value = "一级分类————列表/包含二级分类")
    @PostMapping("/categoryList")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody<CategoryPrimaryDTO> categoryList(HttpServletRequest request, @Validated(value = {Page.class}) @ApiParam(value = "角色查询QO", required = true) @RequestBody CategoryQO param) {
        return ResultBody.success(categoryService.categoryList(param));
    }


    @ApiOperation(value = "二级分类————新增")
    @PostMapping("/addSubCategory")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody addSubCategory(HttpServletRequest request, @RequestBody @Validated(value = {Create.class}) CategorySubVO subVO) {
        return categoryService.addSubCategory(subVO);
    }

    @ApiOperation(value = "二级分类————编辑")
    @PostMapping("/updateSubCategory")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody updateSubCategory(HttpServletRequest request, @RequestBody @Validated(value = {Update.class}) CategorySubVO subVO) {
        return categoryService.updateSubCategory(subVO);
    }


    @ApiOperation(value = "二级分类————删除")
    @GetMapping("/deleteSubCategory")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody deleteSubCategory(HttpServletRequest request, @RequestParam(value = "id", required = true) Integer id) {
        return categoryService.deleteSubCategory(id);
    }

    @ApiOperation(value = "二级分类————详情")
    @GetMapping("/detailSubCategory")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody<CategorySubDTO> detailSubCategory(HttpServletRequest request, @RequestParam(value = "id", required = true) Integer id) {
        return categoryService.detailSubCategory(id);
    }

    @ApiOperation(value = "一级分类——排序交换")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("exchange")
    public ResultBody exchangeBannerInfo(@Validated(Others.class) @RequestBody List<CategoryPrimaryVO> list) {
        return categoryService.exchange(list);
    }

    @ApiOperation(value = "小程序分类信息--含一二级分类")
    @GetMapping("/appCategoryInfo")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CategoryPrimaryDTO.class)})
    public ResultBody<CategoryPrimaryDTO> appCategoryInfo() {
        return categoryService.appCategoryInfo();
    }
}
