package com.mmc.pms.controller;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.model.other.dto.AdDTO;
import com.mmc.pms.model.other.dto.DistrictInfoDTO;
import com.mmc.pms.service.WebDeviceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author small @Date 2023/5/15 13:25 @Version 1.0
 */
@Api(tags = {"web设备租赁-接口"})
@RestController
@RequestMapping("/webDevice")
public class WebDeviceController {

  @Autowired private WebDeviceService webDeviceService;

  @ApiOperation(value = "地域")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
  @GetMapping("/getSecondDistrictInfo")
  public ResultBody<DistrictInfoDTO> getSecondDistrictInfo() {
    return webDeviceService.listSecondDistrict();
  }

  @ApiOperation("设备广告位")
  @GetMapping("/ad")
  public ResultBody<AdDTO> ad() {
    return webDeviceService.ad();
  }
}
