package com.mmc.pms.model.work.vo;

import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author LW
 *
 * @date 2023/6/8 10:33 概要：
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ServiceVO implements Serializable {

  private static final long serialVersionUID = 1L;

  @NotNull(
      message = "修改服务id不能为空",
      groups = {Update.class})
  private Integer id;

  @ApiModelProperty(value = "服务名称", example = "服务名称")
  @NotBlank(
      message = "服务名称不能为空",
      groups = {Create.class, Update.class})
  @Length(message = "最大不超过30字", max = 30)
  private String serviceName;

  @ApiModelProperty(value = "应用", example = "1")
  private Integer applicationId;

  @ApiModelProperty(value = "行业", example = "2")
  @NotNull(
      message = "行业id不能为空",
      groups = {Create.class, Update.class})
  private Integer industryId;

  @ApiModelProperty(value = "展示状态,0为上架，1下架", example = "0")
  @NotNull(
      message = "展示状态不能为空",
      groups = {Create.class, Update.class})
  private Integer displayState;

  @ApiModelProperty(value = "封面图")
  @NotBlank(
      message = "封面图不能为空",
      groups = {Create.class, Update.class})
  private String coverPlan;

  @ApiModelProperty(value = "分享卡片")
  private String shareCard;

  @ApiModelProperty(value = "视频")
  private String video;

  @ApiModelProperty(value = "服务介绍")
  private String serviceIntroduction;
}
