package com.mmc.pms.model.sale.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author small @Date 2023/5/16 16:29 @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class ProductSkuDTO implements Serializable {
    private static final long serialVersionUID = -2681122778843398310L;

    @ApiModelProperty(value = "id")
    private Integer id;

    @ApiModelProperty(value = "产品名称")
    private String productName;

    @ApiModelProperty(value = "产品类型id")
    private Integer categoriesId;

    @ApiModelProperty(value = "产品类型名称")
    private String categoryName;

    @ApiModelProperty(value = "型号")
    private String model;

    @ApiModelProperty(value = "产品品牌")
    private String productBrand;

    @ApiModelProperty(value = "产品品牌id")
    private Integer productBrandId;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "目录id")
    private Integer directoryId;

    @ApiModelProperty(value = "目录名称")
    private String directoryName;

    @ApiModelProperty(value = "产品规格信息对象")
    private List<ProductSpecDTO> productSpecList;
}
