package com.mmc.pms.model.qo;

import com.mmc.pms.common.Page;
import com.mmc.pms.model.group.Freeze;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author LW
 * @date 2022/9/26 11:13
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ProductSkuQO implements Serializable {
    private static final long serialVersionUID = 7548828456935084794L;
    @ApiModelProperty(value = "产品名称")
    private String productName;
    @ApiModelProperty(value = "产品类型")
    private Integer categoryId;
    @ApiModelProperty(value = "产品目录")
    private Integer directoryId;
    @ApiModelProperty(value = "页码", required = true)
    @NotNull(message = "页码不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;
    @ApiModelProperty(value = "每页显示数", required = true)
    @NotNull(message = "每页显示数不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
