package com.mmc.pms.model.lease.vo;

import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.group.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Author small @Date 2023/5/16 17:20 @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "com.mmc.csf.model.vo.WareInfoVO", description = "新增/修改参数类")
public class WareInfoVO implements Serializable {
    private static final long serialVersionUID = -4503117649945902464L;

    @ApiModelProperty(value = "id")
    @NotNull(
            message = "更新时ID不能为空",
            groups = {Update.class})
    private Integer id;

    @ApiModelProperty(value = "商品名称")
    @NotEmpty(
            message = "商品名称不能为空",
            groups = {Create.class})
    @Size(
            max = 60,
            message = "商品名称不能超过60个字符",
            groups = {Create.class, Update.class})
    private String wareTitle;

    @ApiModelProperty(value = "商品类型id")
    @NotNull(
            message = "商品类型ID不能为空",
            groups = {Create.class})
    private Integer wareTypeId;

    @ApiModelProperty(value = "商品活动id")
    private Integer propInfoId;

    @ApiModelProperty(value = "商品活动海报url")
    private String propPoster;

    @ApiModelProperty(value = "商品状态")
    @NotNull(
            message = "商品状态不能为空",
            groups = {Create.class})
    private Integer wareStatus;

    @ApiModelProperty(value = "支付信息（减库方式）")
    @NotNull(
            message = "支付信息（减库方式）不能为空",
            groups = {Create.class})
    private Integer payStatus;

    @ApiModelProperty(value = "一口押金-最小押金")
    @NotNull(
            message = "最小押金不能为空",
            groups = {Create.class})
    @Min(
            value = 0,
            groups = {Create.class, Update.class})
    private BigDecimal minDeposit;

    @ApiModelProperty(value = "一口价-最小日租金")
    @NotNull(
            message = "最小租金不能为空",
            groups = {Create.class})
    @Min(
            value = 0,
            groups = {Create.class, Update.class})
    private BigDecimal minRent;

    @ApiModelProperty(value = "商品标签")
    private String tags;

    @ApiModelProperty(value = "商品总量")
    @Min(
            value = 0,
            groups = {Create.class})
    private Integer totalStock;

    @ApiModelProperty(value = "商品详情")
    @NotEmpty(
            message = "商品详情不能为空",
            groups = {Create.class})
    private String wareDetailContent;

    @ApiModelProperty(value = "sku总数量")
    @Min(
            value = 0,
            groups = {Create.class, Update.class})
    private Integer skuNum;

    @ApiModelProperty(value = "商品图片")
    @NotEmpty(
            message = "商品图片不能为空",
            groups = {Create.class})
    private List<WareImgVO> imgList;

    @ApiModelProperty(value = "新加的商品sku")
    @NotEmpty(
            message = "商品sku不能为空",
            groups = {Create.class})
    private List<WareSkuInfoVO> wareSkuInfoList;

    @ApiModelProperty(value = "更新的商品sku")
    private List<WareSkuInfoVO> updateSkuList;

    @ApiModelProperty(value = "需要删除的sku的id列表")
    private List<Integer> deleteSkuIds;

    @ApiModelProperty(value = "需要删除的照片id列表")
    private List<Integer> deleteImgIds;
}
