package com.mmc.pms.model.lease.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small @Date 2023/5/16 17:23 @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "com.mmc.csf.model.dto.WareDetailDTO", description = "商品详情信息DTO")
public class WareDetailDTO implements Serializable {
  private static final long serialVersionUID = -5359420720425156463L;

  @ApiModelProperty(value = "商品详情id")
  private Integer id;

  @ApiModelProperty(value = "商品id")
  private Integer wareInfoId;

  @ApiModelProperty(value = "商品详情内容")
  private String content;

  @ApiModelProperty(value = "生成时间")
  private Date createTime;

  @ApiModelProperty(value = "更新时间")
  private Date updateTime;
}
