package com.mmc.pms.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * <p>
 * 评论表
 * </p>
 *
 * @author Pika
 * @since 2023-06-09
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class InspComtDO implements Serializable {

    private static final long serialVersionUID = 1896389867L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "头像")
    private String userImg;

    @ApiModelProperty(value = "昵称")
    private String nickName;

    @ApiModelProperty(value = "评价内容")
    private String content;

    @ApiModelProperty(value = "评价图片集合 1.jpg,2.jpg 使用逗号隔开")
    private String contentImgs;

    @ApiModelProperty(value = "评价视频")
    private String contentVideo;

    @ApiModelProperty(value = "评价星级")
    private Integer star;

    @ApiModelProperty(value = "关键字集合 深圳市,广州市,长沙市使用逗号隔开")
    private String tags;

    @ApiModelProperty(value = "是否带图 0：带图 1：不带图")
    private Integer isImg;

    @ApiModelProperty(value = "评价类型：0：好评 1：差评")
    private Integer type;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

}
