package com.mmc.pms.entity;

import com.mmc.pms.model.categories.vo.RelevanceGoodsInfoVO;
import com.mmc.pms.model.lease.dto.LeaseGoodsInfoDTO;
import com.mmc.pms.model.sale.dto.GoodsInfoListDTO;
import com.mmc.pms.model.sale.vo.GoodsAddVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author 23214 @TableName goods_info
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class GoodsInfo implements Serializable {
  private Integer id;

  private Integer pid;

  private String goodsNo;

  private String goodsName;

  private Integer directoryId;

  private Integer addGoodsUserId;

  private Integer categoryByOne;

  private Integer categoryByTwo;

  private String ecoLabel;

  private Integer shelfStatus;

  private Integer showCode;

  private Integer sort;

  private Date createTime;

  private Integer goodsType;

  private Date updateTime;

  private Integer deleted;

  private Integer goodsVideoId;

  private String videoUrl;

  private String mainImg;

  private Integer isCoupons;

  private String directoryName;

  private static final long serialVersionUID = 1L;

  public GoodsInfo(GoodsAddVO goodsAddVO) {
    this.id = goodsAddVO.getId();
    this.goodsName = goodsAddVO.getGoodsName();
    this.shelfStatus = goodsAddVO.getShelfStatus();
    this.categoryByOne = goodsAddVO.getCategoryByOne();
    this.categoryByTwo = goodsAddVO.getCategoryByTwo();
    this.directoryId = goodsAddVO.getDirectoryId();
    this.ecoLabel = goodsAddVO.getTag();
    this.goodsType = goodsAddVO.getGoodsType();
  }

  public GoodsInfo(Integer id) {
    this.id = id;
  }

  public RelevanceGoodsInfoVO buildRelevanceGoodsInfoVO() {
    return RelevanceGoodsInfoVO.builder()
        .id(id)
        .goodsName(goodsName)
        .shelf(shelfStatus)
        .mainImage(mainImg)
        .build();
  }

  public LeaseGoodsInfoDTO buildLeaseGoodsInfoDTO() {
    return LeaseGoodsInfoDTO.builder().id(id).goodsName(goodsName).images(mainImg).build();
  }

  public GoodsInfoListDTO buildGoodsInfoListDTO() {
    return GoodsInfoListDTO.builder()
        .id(id)
        .goodsName(goodsName)
        .directoryName(directoryName)
        .directoryId(directoryId)
        .createTime(createTime)
        .imgUrl(mainImg)
        .status(shelfStatus)
        .isCoupons(this.isCoupons)
        .build();
  }
}
