package com.mmc.pms.dao;


import com.mmc.pms.entity.BrandInfoDO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 * @Author LW
 * @date 2023/3/14 13:27
 * 概要：
 */
@Mapper
public interface BrandManageDao {

    /**
     * 插入品牌信息
     *
     * @param brandInfoDO 品牌信息
     * @return int
     */
    void insertBrandInfo(BrandInfoDO brandInfoDO);

    /**
     * 数品牌信息名字
     * 品牌信息名字计数
     *
     * @param brandName 品牌名称
     * @param id        id
     * @return int
     */
    int countBrandInfoByName(Integer id, String brandName);

    /**
     * 通过id删除品牌信息
     *
     * @param id id
     */
    void removeBrandInfoById(Integer id);

    /**
     * 品牌信息id列表
     *
     * @param ids id
     * @return {@link List}<{@link BrandInfoDO}>
     */
    List<BrandInfoDO> listBrandInfoByIds(@Param("ids") Set<Integer> ids);

    /**
     * 品牌列表信息
     *
     * @param itemIndex 项指数
     * @param pageSize  页面大小
     * @return {@link List}<{@link BrandInfoDO}>
     */
    List<BrandInfoDO> listBrandInfo(Integer itemIndex, Integer pageSize);

    /**
     * 数品牌信息
     *
     * @return int
     */
    int countBrandInfo();

    /**
     * 更新品牌信息
     *
     * @param brandInfoDO 品牌信息做
     */
    void updateBrandInfo(BrandInfoDO brandInfoDO);
}
