package com.mmc.pms.controller;

import com.mmc.pms.common.Page;
import com.mmc.pms.common.ResultBody;
import com.mmc.pms.constant.TokenConstant;
import com.mmc.pms.model.categories.dto.CategoryTypeDTO;
import com.mmc.pms.model.lease.dto.LeaseGoodsInfoDTO;
import com.mmc.pms.model.qo.WareInfoQO;
import com.mmc.pms.model.sale.dto.MallGoodsDetailDTO;
import com.mmc.pms.model.sale.vo.ProductSpecCPQVO;
import com.mmc.pms.service.WebDeviceService;
import io.swagger.annotations.*;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author LW
 *
 * @date 2023/6/8 17:16 概要：
 */
@Api(tags = {"v1.0.1-租赁销售-相关接口"})
@RestController
@RequestMapping("/product/mall")
public class ProductMallController extends BaseController {
  @Autowired private WebDeviceService webDeviceService;

  @ApiOperation(value = "设备列表筛选")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = LeaseGoodsInfoDTO.class)})
  @PostMapping("/deviceList")
  public ResultBody<LeaseGoodsInfoDTO> listWareInfoPage(
      @RequestBody @Validated(Page.class) WareInfoQO param, HttpServletRequest request) {
    return webDeviceService.listWareInfoPage(
        param,
        request,
            StringUtils.isBlank(request.getHeader(TokenConstant.TOKEN))
            ? null
            : this.getUserLoginInfoFromRedis(request).getUserAccountId());
  }

  @ApiOperation(value = "设备商品详情")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = MallGoodsDetailDTO.class)})
  @GetMapping("/getLeaseGoodsDetail")
  public ResultBody<MallGoodsDetailDTO> getLeaseGoodsDetail(
      Integer goodsId,
      HttpServletRequest request,
      @ApiParam(value = "租赁：1  销售商品：0") @RequestParam(value = "type") Integer type) {
    return webDeviceService.getLeaseGoodsDetail(
        goodsId,
            StringUtils.isBlank(request.getHeader(TokenConstant.TOKEN))
            ? null
            : this.getUserLoginInfoFromRedis(request).getUserAccountId(),
        request,
        type);
  }

  @ApiOperation(value = "web-首页分类数据-展示")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CategoryTypeDTO.class)})
  @GetMapping("/getPageHomeCategories")
  public ResultBody<CategoryTypeDTO> getPageHomeCategories(
      @ApiParam(value = "类型:1：作业服务 2：设备 3：培训 4：产品商城") @RequestParam(value = "type") Integer type) {
    return webDeviceService.getPageHomeCategories(type);
  }

  @ApiOperation(value = "获取设备商品规格价格详情")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ProductSpecCPQVO.class)})
  @GetMapping("/getLeaseGoodsPriceDetail")
  public ResultBody<ProductSpecCPQVO> getLeaseGoodsPriceDetail(
      @ApiParam(value = "商品id") @RequestParam(value = "productSpecId") Integer productSpecId,
      @ApiParam(value = "租赁时限：（输入0：1-7天、输入1：8-15天、输入2：16-30天、输入3：30天以上）")
          @RequestParam(value = "leaseTerm")
          Integer leaseTerm) {
    return webDeviceService.getLeaseGoodsPriceDetail(productSpecId, leaseTerm);
  }
}
