package com.mmc.pms.controller;


import com.mmc.pms.common.ResultBody;
import com.mmc.pms.entity.Categories;
import com.mmc.pms.model.categories.dto.CategoriesDTO;
import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.qo.ServiceQO;
import com.mmc.pms.model.work.dto.ServiceDTO;
import com.mmc.pms.page.PageResult;
import com.mmc.pms.service.CategoriesService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author Pika
 * @since 2023-06-08
 */
@Api(tags = {"后台-目录管理-接口"})
@RestController
@RequestMapping("/directory")
public class DirectoryController {

    private final String DIRECTORY_NAME_APPLICATION = "应用";
    private final String DIRECTORY_NAME_INDUSTRY = "行业";

    @Autowired
    private CategoriesService categoriesService;

    @ApiOperation(value = "获取应用类型列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CategoriesDTO.class)})
    @PostMapping("getApplicationList")
    public ResultBody<CategoriesDTO> getApplicationList() {
        return categoriesService.getApplicationList(DIRECTORY_NAME_APPLICATION);
    }

    @ApiOperation(value = "获取对应行业列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CategoriesDTO.class)})
    @PostMapping("getIndustryList")
    public ResultBody<CategoriesDTO> getIndustryList() {
        return categoriesService.getApplicationList(DIRECTORY_NAME_INDUSTRY);
    }
}

