package com.mmc.pms.common;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author small @Date 2023/5/15 14:28 @Version 1.0
 */
// @Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
// @ApiModel("统一返回对象")
// @ApiModel(value = "com.mmc.result.ResultBody", description = "请求响应体")
public class ResultBody<T> implements Serializable {
  private static final long serialVersionUID = 6341937455634693363L;

  /** 响应代码 */
  @ApiModelProperty(name = "code", value = "响应码", required = true, example = "200", position = 0)
  private String code;

  /** 响应消息 */
  @ApiModelProperty(
      name = "message",
      value = "响应消息",
      required = true,
      example = "操作成功",
      position = 1)
  private String message;

  /** 响应结果 */
  @ApiModelProperty(name = "result", value = "返回结果集", required = true, example = "{}", position = 2)
  private T result;

  public ResultBody(BaseErrorInfoInterface errorInfo) {
    this.code = errorInfo.getResultCode();
    this.message = errorInfo.getResultMsg();
  }

  /**
   * 成功
   *
   * @return
   */
  public static ResultBody success() {
    return success(null);
  }

  /**
   * 成功
   *
   * @param data
   * @return
   */
  public static <T> ResultBody success(T data) {
    ResultBody rb = new ResultBody();
    rb.setCode(ResultEnum.SUCCESS.getResultCode());
    rb.setMessage(ResultEnum.SUCCESS.getResultMsg());
    rb.setResult(data);
    return rb;
  }

  /**
   * 成功
   *
   * <p>*
   */
  public static ResultBody success1(ResultEnum enums) {
    ResultBody rb = new ResultBody();
    rb.setCode("200");
    rb.setMessage(enums.getResultMsg());
    rb.setResult(null);
    return rb;
  }

  public void buildSuccess() {
    this.setCode(ResultEnum.SUCCESS.getResultCode());
    this.setMessage(ResultEnum.SUCCESS.getResultMsg());
  }

  /** 失败 */
  public static ResultBody error(BaseErrorInfoInterface errorInfo) {
    ResultBody rb = new ResultBody();
    rb.setCode(errorInfo.getResultCode());
    rb.setMessage(errorInfo.getResultMsg());
    rb.setResult(null);
    return rb;
  }

  /** 失败 */
  public static ResultBody error(String code, String message) {
    ResultBody rb = new ResultBody();
    rb.setCode(code);
    rb.setMessage(message);
    rb.setResult(null);
    return rb;
  }

  /** 失败 */
  public static ResultBody error(ResultEnum enums) {
    ResultBody rb = new ResultBody();
    rb.setCode(enums.getResultCode());
    rb.setMessage(enums.getResultMsg());
    rb.setResult(null);
    return rb;
  }

  /** 失败 */
  public static ResultBody error(String message) {
    ResultBody rb = new ResultBody();
    rb.setCode("-1");
    rb.setMessage(message);
    rb.setResult(null);
    return rb;
  }

  /** 失败 */
  public static ResultBody error(ResultEnum enums, Object data) {
    ResultBody rb = new ResultBody();
    rb.setCode(enums.getResultCode());
    rb.setMessage(enums.getResultMsg());
    rb.setResult(data);
    return rb;
  }

  public static boolean isSuccess(ResultBody res) {
    return res.getCode().equals(ResultEnum.SUCCESS.getResultCode());
  }

  @Override
  public String toString() {
    return JSONObject.toJSONString(this);
  }
}
