package com.mmc.pms.entity.category;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.mmc.pms.model.category.dto.CategorySubDTO;
import com.mmc.pms.model.category.vo.CategorySubVO;
import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/7/21 10:16
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class CategorySubDO {
    @ApiModelProperty(value = "id")
    @NotNull(message = "id不能为空", groups = {Update.class})
    @Min(value = 1, groups = {Update.class})
    @TableId(type = IdType.AUTO)
    private Integer id;


    @ApiModelProperty(value = "分类名称", required = true, example = "无人机")
    @Size(max = 15, message = "分类名称不能超过15个字", groups = {Update.class, Create.class})
    @NotBlank(message = "分类名称不能为空或空字符", groups = {Update.class, Create.class})
    private String name;

    @ApiModelProperty(value = "描述")
    @Size(max = 70, message = "分类描述不能超过70个字", groups = {Update.class, Create.class})
    private String description;

    @ApiModelProperty(value = "一级id不能为空", required = true, example = "1")
    @NotNull(message = "一级id不能为空", groups = {Update.class, Create.class})
    private Integer categoryPrimaryId;


    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间", example = "2023-07-14 10:13:12", required = true)
    private Date createTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新时间", example = "2023-07-14 10:13:12", required = true)
    private Date updateTime;

    public CategorySubDO(CategorySubVO subVO) {
        this.id = subVO.getId();
        this.name = subVO.getName();
        this.description = subVO.getDescription();
        this.categoryPrimaryId = subVO.getCategoryPrimaryId();
    }

    public CategorySubDTO buildCategorySubDTO() {
        return CategorySubDTO.builder()
                .id(this.id)
                .name(this.name)
                .description(this.description)
                .categoryPrimaryId(this.categoryPrimaryId)
                .createTime(this.createTime)
                .updateTime(this.updateTime)
                .build();
    }
}
