package com.mmc.pms.service.Impl;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.dao.WebDeviceDao;
import com.mmc.pms.entity.*;
import com.mmc.pms.model.dto.*;
import com.mmc.pms.model.qo.WareInfoQO;
import com.mmc.pms.model.vo.LeaseVo;
import com.mmc.pms.page.PageResult;
import com.mmc.pms.service.WebDeviceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author small @Date 2023/5/15 14:32 @Version 1.0
 */
@Service
public class WebDeviceServiceImpl implements WebDeviceService {

  @Autowired WebDeviceDao webDeviceDao;

  @Override
  public ResultBody listSecondDistrict() {
    List<DistrictDO> list = webDeviceDao.listSecondDistrict();
    List<DistrictInfoDTO> dtoList =
        list.stream()
            .map(
                d -> {
                  return d.builderDistrictInfoDTO();
                })
            .collect(Collectors.toList());
    return ResultBody.success(dtoList);
  }

  @Override
  public ResultBody category() {
    List<DeviceCategory> category = webDeviceDao.category();
    List<DeviceCategoryDTO> collect =
        category.stream()
            .map(
                t -> {
                  return t.deviceCategory();
                })
            .collect(Collectors.toList());
    return ResultBody.success(collect);
  }

  @Override
  public ResultBody brand() {
    List<Brand> brand = webDeviceDao.brand();
    List<BrandDTO> collect =
        brand.stream()
            .map(
                t -> {
                  return t.brandDTO();
                })
            .collect(Collectors.toList());
    return ResultBody.success(collect);
  }

  @Override
  public ResultBody deviceBrand() {
    List<Brand> brand = webDeviceDao.deviceBrand();
    List<BrandDTO> collect =
            brand.stream()
                    .map(
                            t -> {
                              return t.brandDTO();
                            })
                    .collect(Collectors.toList());
    return ResultBody.success(collect);
  }

  @Override
  public ResultBody model() {
    List<Model> model = webDeviceDao.model();
    List<ModelDTO> collect =
        model.stream()
            .map(
                t -> {
                  return t.modelDTO();
                })
            .collect(Collectors.toList());
    return ResultBody.success(collect);
  }

  @Override
  public ResultBody deviceModel() {
    List<Model> model = webDeviceDao.deviceModel();
    List<ModelDTO> collect =
            model.stream()
                    .map(
                            t -> {
                              return t.modelDTO();
                            })
                    .collect(Collectors.toList());
    return ResultBody.success(collect);
  }

  @Override
  public ResultBody deviceList(
      Integer districtId, Integer categoryId, Integer brandId, Integer modelId) {
    List<DeviceListDO> deviceList =
        webDeviceDao.deviceList(districtId, categoryId, brandId, modelId);
    List<DeviceListDTO> collect =
        deviceList.stream()
            .map(
                t -> {
                  return t.deviceListDTO();
                })
            .collect(Collectors.toList());
    return ResultBody.success(collect);
  }

  @Override
  public ResultBody update(LeaseVo param) {
    InventoryDO inventory = webDeviceDao.findInventory(param.getInventoryId());
    Integer residueCount = inventory.getResidueCount();
    Integer count = residueCount - param.getInventoryUsage();
    param.setInventoryUsage(count);
    int update = webDeviceDao.update(param);
    return ResultBody.success(update);
  }

  @Override
  public ResultBody detail(Integer id) {
    List<WareInfoDO> list = webDeviceDao.detail(id);
    List<WareInfoItemDTO> pageList =
        list.stream()
            .map(
                d -> {
                  return d.buildWareInfoItemDTO();
                })
            .collect(Collectors.toList());
    return ResultBody.success(pageList);
  }

  @Override
  public ResultBody listWareInfoPage(WareInfoQO param) {
    int count = webDeviceDao.countListWareInfoPage(param);
    if (count == 0) {
      return ResultBody.success(
          PageResult.buildPage(param.getPageNo(), param.getPageSize(), count));
    }
    int pageNo = param.getPageNo();
    param.buildCurrentPage();
    List<WareInfoDO> list = webDeviceDao.listWareInfoPage(param);
    List<WareInfoItemDTO> pageList =
        list.stream()
            .map(
                d -> {
                  return d.buildWareInfoItemDTO();
                })
            .collect(Collectors.toList());
    return ResultBody.success(PageResult.buildPage(pageNo, param.getPageSize(), count, pageList));
  }

  @Override
  public WareInfoDTO getWareInfoById(Integer id) {
    WareInfoDO wareInfoDO = webDeviceDao.getWareInfoById(id);
    WareDetailDO wareDetailDO = webDeviceDao.getWareDetailById(id);
    if (wareInfoDO != null) {
      wareInfoDO.setWareDetailContent(wareDetailDO.getContent());
    }
    return wareInfoDO == null ? null : wareInfoDO.buildWareInfoDTO();
  }

  @Override
  public ResultBody<AdDTO> ad() {
    List<AdDO> ad = webDeviceDao.ad();
    List<AdDTO> collect =
            ad.stream()
                    .map(
                            t -> {
                              return t.adDTO();
                            })
                    .collect(Collectors.toList());
    return ResultBody.success(collect);
  }
  @Override
  public List<SkuInfoDTO> listWareSkuById(Integer id) {
    List<SkuInfoDO> skuInfoDOS = webDeviceDao.listSkuInfo(id);
    return skuInfoDOS.isEmpty() ? null : skuInfoDOS.stream().map(d -> {
      return d.buildSkuInfoDTO();
    }).collect(Collectors.toList());
  }

}
