package com.mmc.pms.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/5/19 19:55
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.dto.SkuPriceDTO", description = "sku价格信息DTO")
public class SkuPriceDTO implements Serializable {
    private static final long serialVersionUID = 7304698187458849560L;
    @ApiModelProperty(value = "sku价格表id")
    private Integer id;
    @ApiModelProperty(value = "商品id")
    private Integer wareInfoId;
    @ApiModelProperty(value = "sku表id")
    private Integer skuInfoId;
    @ApiModelProperty(value = "周期租金")
    private BigDecimal rentPrice;
    @ApiModelProperty(value = "起租天数")
    private Integer minDay;
    @ApiModelProperty(value = "截租天数")
    private Integer maxDay;
    @ApiModelProperty(value = "生成时间")
    private Date createTime;
}
