package com.mmc.pms.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author small
 * @Date 2023/5/19 19:51
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.dto.SkuInfoDTO", description = "sku信息DTO")
public class SkuInfoDTO implements Serializable {
    private static final long serialVersionUID = -4321518089785860606L;
    @ApiModelProperty(value = "sku表id")
    private Integer id;
    @ApiModelProperty(value = "商品id")
    private Integer wareInfoId;
    @ApiModelProperty(value = "sku标题")
    private String skuTitle;
    @ApiModelProperty(value = "基础租金（日租金）")
    private BigDecimal rentPrice;
    @ApiModelProperty(value = "出租押金")
    private BigDecimal rentDeposit;
    @ApiModelProperty(value = "库存数量")
    private Integer stockNum;
    @ApiModelProperty(value = "已销数量")
    private Integer saleNum;
    @ApiModelProperty(value = "生成时间")
    private Date createTime;
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    @ApiModelProperty(value = "sku对应价格")
    private List<SkuPriceDTO> skuPriceDTOList;
}
