package com.mmc.pms.entity;

import com.mmc.pms.model.dto.GoodsImgDTO;
import com.mmc.pms.model.vo.GoodsImgVO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small @Date 2023/5/16 15:10 @Version 1.0
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Builder
public class GoodsImgDO implements Serializable {

  private Integer id;
  private Integer goodsInfoId;
  private String imgUrl;
  private Integer imgType;
  private Integer deleted;
  private Date createTime;

  public GoodsImgDO(GoodsImgVO d) {
    this.imgUrl = d.getImgUrl();
    this.imgType = d.getImgType();
  }

  public GoodsImgDTO buildGoodsImgDTO() {
    return GoodsImgDTO.builder().id(this.id).imgUrl(this.imgUrl).imgType(this.imgType).build();
  }
}
