package com.mmc.pms.model.dto;

import com.mmc.pms.model.vo.Create;
import com.mmc.pms.model.vo.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author small @Date 2023/5/16 15:05 @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ProductSkuVO implements Serializable {
    private static final long serialVersionUID = -2681122778843398310L;

    @ApiModelProperty(value = "id")
    @NotNull(message = "修改时id不能为空", groups = {Update.class})
    private Integer id;

    @NotNull(message = "产品名称不能为空", groups = {Update.class, Create.class})
    @ApiModelProperty(value = "产品名称")
    private String productName;

    @NotNull(message = "产品类型id不能为空", groups = {Update.class, Create.class})
    @ApiModelProperty(value = "产品类型id")
    private Integer categoryId;

    @ApiModelProperty(value = "型号")
    private String model;

    @ApiModelProperty(value = "品牌id")
    private Integer productBrandId;

    @ApiModelProperty(value = "目录id")
    private Integer directoryId;
}
