package com.mmc.pms.model.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small @Date 2023/5/16 13:29 @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
// @ApiModel(value = "com.mmc.csf.mall.dto.GoodsInfoListDTO", description = "商品列表信息DTO")
public class GoodsInfoListDTO implements Serializable {
  @ApiModelProperty(value = "id")
  private Integer id;

  @ApiModelProperty(value = "商品名称")
  private String goodsName;

  @ApiModelProperty(value = "创建时间")
  private Date createTime;

  @ApiModelProperty(value = "状态 : 0:下架 1：上架")
  private Integer status;

  @ApiModelProperty(value = "商品主图")
  private String imgUrl;

  @ApiModelProperty(value = "一级分类名称")
  private String goodsOneLevelTypeName;

  @ApiModelProperty(value = "二级分类名称")
  private String goodsTwoLevelTypeName;

  @ApiModelProperty(value = "目录名字")
  private String directoryName;

  @ApiModelProperty(value = "目录id")
  private Integer directoryId;

  @ApiModelProperty(value = "是否有优惠券 0表示没有 有就返回数字")
  private Integer isCoupons;

  @ApiModelProperty(value = "描述")
  private String goodsDesc;
}
