package com.mmc.pms.entity;

import com.mmc.pms.model.dto.OrderGoodsIndstDetailDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

/**
 * author:zhenjie
 * Date:2022/10/20
 * time:16:47
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MallGoodsSpecSimpleDO implements Serializable {
    private static final long serialVersionUID = 1452073707519053399L;
    private Integer mallIndustrySkuInfoSpecId;
    private Integer industrySpecId;
    private String specName;
    private String specImage;
    private BigDecimal unitPrice;
    private Integer skuInfoDeleted;
    private Integer skuSpecDeleted;
    private Integer specDeleted;
    private String unitName;

    private List<MallGoodsProductDO> mallGoodsProductDOS;

    public OrderGoodsIndstDetailDTO buildOrderGoodsIndstDetailDTO() {
        return OrderGoodsIndstDetailDTO.builder().mallIndstSkuInfoSpecId(this.mallIndustrySkuInfoSpecId).industrySpecId(this.industrySpecId).industrySkuSpecName(this.specName)
                .industrySkuSpecImage(this.specImage).unitPrice(this.unitPrice).valid(this.skuInfoDeleted.equals(0) && this.skuSpecDeleted.equals(0) && this.specDeleted.equals(0) ? true : false)
                .orderGoodsIndstProdListDTOS(mallGoodsProductDOS == null ? null : mallGoodsProductDOS.stream().map(d -> d.buildOrderGoodsIndstProdListDTO()).collect(Collectors.toList()))
                .unitName(this.unitName).build();
    }
}
