package com.mmc.pms.entity;

import com.mmc.pms.model.dto.IndustrySpecPriceDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author LW
 * @date 2022/10/13 16:10
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class IndustrySpecPriceDO implements Serializable {
    private static final long serialVersionUID = -6424007941913778680L;
    private Integer id;
    private Integer industrySpecId;
    private Integer cooperationTag;
    private BigDecimal price;
    private Date createTime;
    private Date updateTime;
    private Integer deleted;
    private Integer type;
    private Integer leaseTerm;

    public IndustrySpecPriceDTO buildIndustrySpecPriceDTO() {
        return IndustrySpecPriceDTO.builder().id(this.id).industrySpecId(this.industrySpecId)
                .cooperationTag(this.cooperationTag).leaseTerm(leaseTerm).price(this.price).createTime(this.createTime).build();
    }
}
