package com.mmc.pms.entity;

import com.mmc.pms.model.dto.IndustrySkuDTO;
import com.mmc.pms.model.vo.IndustrySkuVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 行业sku表(IndustrySku)实体类
 *
 * @author makejava
 * @since 2023-05-30 15:01:54
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class IndustrySku implements Serializable {
    private static final long serialVersionUID = 165189738203335092L;

    private Integer id;

    private String solutionName;

    private Integer categoriesId;

    private String description;

    private Date createTime;

    private Date updateTime;

    private Integer deleted;

    private String typeName;

    public IndustrySku(IndustrySkuVO param) {
        this.id = param.getId();
        this.solutionName = param.getSolutionName();
        this.categoriesId = param.getCategoryId();
        this.description = param.getDescription();
    }

    public IndustrySkuVO buildIndustrySku() {
        return IndustrySkuVO.builder().id(this.id).description(this.description)
                .categoryId(this.categoriesId).categoryName(typeName).solutionName(this.solutionName).build();
    }

    public IndustrySkuDTO buildIndustrySkuDTO() {
        return IndustrySkuDTO.builder().id(this.id).description(this.description)
                .createTime(this.createTime).categoryId(this.categoriesId)
                .categoryName(this.typeName).solutionName(this.solutionName).build();
    }
}

