package com.mmc.pms.dao.lease;

import com.mmc.pms.entity.lease.*;
import com.mmc.pms.entity.mall.MallGoodsResourcesDO;
import com.mmc.pms.entity.mall.SpecAttrDO;
import com.mmc.pms.entity.mall.SpecAttrValueDO;
import com.mmc.pms.model.lease.qo.LeaseGoodsQO;
import com.mmc.pms.model.lease.vo.LeaseGoodsVO;
import com.mmc.pms.model.mall.SpecAttrVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Author LW
 * @date 2023/8/4 10:38
 * 概要：
 */
@Mapper
public interface LeaseGoodsDao {
    int countLeaseGoodsByName(@Param("leaseGoodsVO") LeaseGoodsVO leaseGoodsVO, @Param("userAccountId") Integer userAccountId);

    int countLeaseGoodsByUserAccountId(Integer userAccountId);

    void insertLeaseGoodsBaseInfo(LeaseGoodsDO leaseGoodsDO);

    void batchInsertLeaseGoodsResources(List<MallGoodsResourcesDO> mallGoodsResourcesList);

    void insertSpecAttr(SpecAttrDO specAttrDO);

    void batchInsertSpecAttr(List<SpecAttrValueDO> list);

    void batchInsertPriceStock(List<LeasePriceStockDO> list);

    void batchInsertLeaseParts(List<LeasePartsListDO> list);

    List<LeaseTermInfoDO> getLeaseTermInfo();

    LeaseGoodsDO getLeaseGoodsBaseInfo(Integer id);

    List<LeaseGoodsResourcesDO> getLeaseGoodsResources(Integer id);

    List<LeaseSpecAttrDO> listSpecAttr(Integer id);

    List<LeasePriceStockDO> listPriceStock(Integer id);

    List<LeasePartsListDO> listLeasePartsListDO(Integer id);

    void updateLeaseGoodsBaseInfo(LeaseGoodsDO leaseGoodsDO);

    void deleteLeaseGoodsResources(Integer id);

    void deleteLeasePartsList(Integer id);

    void deleteSpecAttr(List<Integer> list);

    void deleteLeasePriceStock(Integer id);

    List<LeaseSpecAttrDO> getLeaseSpecAttr(List<Integer> ids);

    void updateSpecAttr(SpecAttrVO specAttrVO);

    void deleteSpecAttrValue(List<Integer> delValueIds);

    int countLeaseGoods(LeaseGoodsQO param);

    List<LeaseGoodsDO> listLeaseGoods(LeaseGoodsQO param);

    void batchOnShelfOrTakeDown(@Param("list") List<Integer> list, @Param("status") Integer status);

    void removeWareInfo(List<Integer> list);

    int feignLeaseGoodsInfoByAddressId(Integer id);

    int countLeaseGoodsByApp(LeaseGoodsQO param);

    List<LeaseGoodsDO> listLeaseGoodsByApp(LeaseGoodsQO param);
}
