package com.mmc.pms.controller.lease;

/**
 * @Author LW
 * @date 2023/8/4 10:35
 * 概要：
 */

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.controller.BaseController;
import com.mmc.pms.model.lease.qo.LeaseGoodsQO;
import com.mmc.pms.model.lease.vo.LeaseGoodsVO;
import com.mmc.pms.service.lease.LeaseGoodsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @Author LW
 * @date 2023/7/24 16:56 概要：
 */
@RestController
@RequestMapping("/app/lease/")
@Api(tags = {"V1.0.3-小程序-租赁商品-相关接口"})
public class AppGoodsController extends BaseController {
    @Resource
    LeaseGoodsService leaseGoodsService;

    @ApiOperation(value = "租赁商品详情")
    @GetMapping("leaseGoodsDetails")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = LeaseGoodsVO.class)})
    public ResultBody<LeaseGoodsVO> leaseGoodsDetails(@RequestParam Integer id) {
        return leaseGoodsService.leaseGoodsDetails(id);
    }

    @ApiOperation(value = "租赁商品列表")
    @PostMapping("leaseGoodsList")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = LeaseGoodsVO.class)})
    public ResultBody leaseGoodsList(@RequestBody LeaseGoodsQO param) {
        return leaseGoodsService.leaseGoodsList(param, null);
    }
}
