package com.mmc.pms.service.lease.impl;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.dao.lease.LeaseGoodsDao;
import com.mmc.pms.entity.lease.LeaseGoodsDO;
import com.mmc.pms.entity.lease.LeasePartsListDO;
import com.mmc.pms.model.lease.vo.LeaseGoodsVO;
import com.mmc.pms.model.lease.vo.LeasePartsListVO;
import com.mmc.pms.service.lease.LeaseGoodsService;
import com.mmc.pms.service.mall.MallGoodsService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author LW
 * @date 2023/8/4 10:37
 * 概要：
 */
@Service
public class LeaseGoodsServiceImpl implements LeaseGoodsService {
    @Resource
    MallGoodsService mallGoodsService;
    @Resource
    LeaseGoodsDao leaseGoodsDao;

    @Override
    public ResultBody addLeaseGoods(LeaseGoodsVO leaseGoodsVO, Integer userAccountId) {
        ResultBody resultError = mallGoodsService.checkInformation(leaseGoodsVO, null, userAccountId);
        if (resultError != null) return resultError;
        int count = leaseGoodsDao.countLeaseGoodsByUserAccountId(userAccountId);
        LeaseGoodsDO leaseGoodsDO = new LeaseGoodsDO(leaseGoodsVO);
        leaseGoodsDO.setUserAccountId(userAccountId);
        leaseGoodsDO.setSort(count + 1);
        // 将租赁商品基本信息存储入数据库
        leaseGoodsDao.insertLeaseGoodsBaseInfo(leaseGoodsDO);
        // 将商品图片等资源存入数据库中
        mallGoodsService.insertMallGoodsResources(leaseGoodsVO, null, leaseGoodsDO.getId());
        // 将商品规格存入数据库
        mallGoodsService.addMallGoodsSpec(leaseGoodsVO.getSpecAttrList(), leaseGoodsDO.getId(), null, leaseGoodsVO.getPriceStock(), 1);
        // 将商品清单入库
        insertLeasePartsList(leaseGoodsVO.getLeasePartsList(), leaseGoodsDO.getId());
        return ResultBody.success();
    }

    @Transactional(rollbackFor = Exception.class)
    public void insertLeasePartsList(List<LeasePartsListVO> leasePartsList, Integer id) {
        if (CollectionUtils.isNotEmpty(leasePartsList)) {
            List<LeasePartsListDO> list = leasePartsList.stream().map(d -> {
                LeasePartsListDO leasePartsListDO = new LeasePartsListDO(d);
                leasePartsListDO.setLeaseGoodsId(id);
                return leasePartsListDO;
            }).collect(Collectors.toList());
            leaseGoodsDao.batchInsertLeaseParts(list);
        }
    }
}
