package com.mmc.pms.service.inspection.impl;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.common.ResultEnum;
import com.mmc.pms.dao.inspection.InspectionTagDao;
import com.mmc.pms.entity.inspection.InspectionTagDO;
import com.mmc.pms.model.inspection.dto.InspectionTagDTO;
import com.mmc.pms.model.inspection.vo.InspectionTagVO;
import com.mmc.pms.service.inspection.InspectionTagService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/8/5 14:54
 */
@Service
public class InspectionTagServiceImpl implements InspectionTagService {
    @Autowired
    private InspectionTagDao inspectionTagDao;

    @Override
    public ResultBody insert(InspectionTagVO inspectionTagVO) {
        int count = inspectionTagDao.countSameName(inspectionTagVO.getTagName());
        if (count > 0) {
            return ResultBody.error(ResultEnum.NAME_DUPLICATION_ERROR);
        }
        InspectionTagDO inspectionTagDO = new InspectionTagDO(inspectionTagVO);
        inspectionTagDao.insert(inspectionTagDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody update(InspectionTagVO inspectionTagVO) {
        int count = inspectionTagDao.countSameName(inspectionTagVO.getTagName());
        if (count > 0) {
            return ResultBody.error(ResultEnum.NAME_DUPLICATION_ERROR);
        }
        InspectionTagDO inspectionTagDO = new InspectionTagDO(inspectionTagVO);
        inspectionTagDao.update(inspectionTagDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody delete(Integer id) {
        inspectionTagDao.delete(id);
        return ResultBody.success();
    }

    @Override
    public ResultBody<InspectionTagDTO> listByInspectionId(Integer id) {
        List<InspectionTagDO> inspectionTagDOS = inspectionTagDao.listByInspectionId(id);
        if (CollectionUtils.isNotEmpty(inspectionTagDOS)){
            List<InspectionTagDTO> inspectionTagDTOS = inspectionTagDOS.stream().map(InspectionTagDO::buildInspectionTagDTO).collect(Collectors.toList());
            return ResultBody.success(inspectionTagDTOS);
        }
        return ResultBody.success();
    }
}
