package com.mmc.pms.service.inspection.impl;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.common.ResultEnum;
import com.mmc.pms.dao.inspection.IndustryTypeDao;
import com.mmc.pms.entity.inspection.IndustryTypeDO;
import com.mmc.pms.entity.inspection.InspectionDO;
import com.mmc.pms.model.inspection.dto.IndustryTypeDTO;
import com.mmc.pms.model.inspection.dto.InspectionDTO;
import com.mmc.pms.model.inspection.vo.IndustryTypeVO;
import com.mmc.pms.model.qo.IndustryTypeQO;
import com.mmc.pms.page.PageResult;
import com.mmc.pms.service.inspection.IndustryTypeService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/8/3 18:01
 */
@Service
public class IndustryTypeServiceImpl implements IndustryTypeService {
    @Autowired
    private IndustryTypeDao industryTypeDao;

    @Override
    public ResultBody insert(IndustryTypeVO industryTypeVO) {
        int count = industryTypeDao.countSameName(industryTypeVO.getId(), industryTypeVO.getTypeName());
        if (count > 0) {
            return ResultBody.error(ResultEnum.INDUSTRY_NAME_CREATE_ERROR);
        }
        IndustryTypeDO industryTypeDO = new IndustryTypeDO(industryTypeVO);
        industryTypeDao.insert(industryTypeDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody update(IndustryTypeVO industryTypeVO) {
        int count = industryTypeDao.countSameName(industryTypeVO.getId(), industryTypeVO.getTypeName());
        if (count > 0) {
            return ResultBody.error(ResultEnum.INDUSTRY_NAME_CREATE_ERROR);
        }
        IndustryTypeDO industryTypeDO = new IndustryTypeDO(industryTypeVO);
        industryTypeDao.update(industryTypeDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody remove(Integer id) {
        // 有绑定则不能删除
        industryTypeDao.remove(id);
        return ResultBody.success();
    }

    @Override
    public ResultBody listPages(IndustryTypeQO industryTypeQO) {
        int count = industryTypeDao.countListPages(industryTypeQO);
        if (count == 0) {
            return ResultBody.success(PageResult.buildPage(industryTypeQO.getPageNo(), industryTypeQO.getPageSize(), count));
        }
        int pageNo = industryTypeQO.getPageNo();
        industryTypeQO.buildCurrentPage();
        List<IndustryTypeDO> industryTypeDOS = industryTypeDao.listPages(industryTypeQO);
        List<IndustryTypeDTO> pageList = industryTypeDOS.stream().map(IndustryTypeDO::buildIndustryTypeDTO).collect(Collectors.toList());
        return ResultBody.success(PageResult.buildPage(pageNo, industryTypeQO.getPageSize(), count, pageList));
    }

    @Override
    public ResultBody<IndustryTypeDTO> listInspectionsByIndustryTypeId(Integer id) {
        List<InspectionDO> industryTypeDOS = industryTypeDao.listInspectionsByIndustryTypeIdId(id);
        if (CollectionUtils.isNotEmpty(industryTypeDOS)) {
            List<InspectionDTO> inspectionDTOS = industryTypeDOS.stream().map(InspectionDO::buildInspectionDTO).collect(Collectors.toList());
            return ResultBody.success(inspectionDTOS);
        }
        return ResultBody.success();
    }
}
