package com.mmc.pms.model.qo;

import com.mmc.pms.common.Page;
import com.mmc.pms.model.group.Freeze;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author: zj
 * @Date: 2023/8/7 14:44
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class CompanyInspectionQO implements Serializable {
    private static final long serialVersionUID = -5974353165131012551L;
    @ApiModelProperty(value = "关键字")
    private String keyword;
    @ApiModelProperty(value = "行业id")
    private Integer industryTypeId;
    @ApiModelProperty(value = "服务id")
    private Integer inspectionId;
    @ApiModelProperty(value = "作业团队id")
    private Integer companyInfoId;
    @ApiModelProperty(value = "页码", required = true)
    @NotNull(message = "页码不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;
    @ApiModelProperty(value = "每页显示数", required = true)
    @NotNull(message = "每页显示数不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
