package com.mmc.pms.model.lease.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author LW
 * @date 2023/8/8 10:48
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class LeasePriceStockVO implements Serializable {

    private static final long serialVersionUID = 1011141620995647903L;
    @ApiModelProperty(value = "id", example = "1")
    private Integer id;

    @ApiModelProperty(value = "商品规格", example = "示例：{\"颜色\":\"蓝色\",\"尺寸\":\"1寸\",\"大小\":\"小\"} 或 [\"颜色\":\"蓝色\",\"尺寸\":\"1寸\",\"大小\":\"小\"] 或 你怎么方便怎么来")
    private String productSpec;

    @ApiModelProperty(value = "押金", example = "1")
    private BigDecimal cashPledge;

    @ApiModelProperty(value = "3天租金", example = "1")
    private BigDecimal threeDaysRental;

    @ApiModelProperty(value = "7天租金", example = "1")
    private BigDecimal sevenDaysRental;

    @ApiModelProperty(value = "30天租金", example = "1")
    private BigDecimal thirtyDaysRental;

    @ApiModelProperty(value = "90天租金", example = "1")
    private BigDecimal ninetyDaysRental;

    @ApiModelProperty(value = "180天租金", example = "1")
    private BigDecimal maxDaysRental;

    @ApiModelProperty(value = "展示最低价", example = "1")
    private BigDecimal showPrice;

    @ApiModelProperty(value = "sku图片", example = "https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/35bbd044-7cd7-4c85-ba27-69776e03dbb2.jpg")
    private String skuImage;

    @ApiModelProperty(value = "库存", example = "10")
    private Integer stock;

    @ApiModelProperty(value = "是否缺货 0：否 1：是")
    private Integer stockOut;

}
