package com.mmc.pms.model.lease.vo;

import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.group.Update;
import com.mmc.pms.model.mall.GoodsResourcesVO;
import com.mmc.pms.model.mall.SpecAttrVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author LW
 * @date 2023/7/24 17:44
 * 概要：
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class LeaseGoodsVO implements Serializable {
    private static final long serialVersionUID = -3147170430919703826L;

    @ApiModelProperty(value = "id", example = "1")
    @NotNull(message = "id不能为空", groups = {Update.class})
    private Integer id;

    @ApiModelProperty(value = "商品标题", example = "商品标题", required = true)
    @NotBlank(message = "商品标题不能为空", groups = {Update.class, Create.class})
    private String tradeName;

    @ApiModelProperty(value = "商品卖点", example = "商品卖点")
    private String sellingPoint;

    @ApiModelProperty(value = "商品成新", example = "1", required = true)
    private Integer level;

    @ApiModelProperty(value = "商品状态", example = "1", required = true)
    @NotNull(message = "商品状态不能为空", groups = {Update.class, Create.class})
    private Integer shelfStatus;

    @ApiModelProperty(value = "商品类型id", example = "1", required = true)
    @NotNull(message = "商品类型id不能为空", groups = {Update.class, Create.class})
    private Integer productTypeId;

    @ApiModelProperty(value = "品牌id", example = "2", required = true)
    @NotNull(message = "品牌id不能为空", groups = {Update.class, Create.class})
    private Integer brandInfoId;

    @ApiModelProperty(value = "型号id", example = "2", required = true)
    @NotNull(message = "型号id不能为空", groups = {Update.class, Create.class})
    private Integer deviceModeId;

    @ApiModelProperty(value = "商品参数", example = "示例：[{\"起飞重量\":\"595g\"}]")
    private String productParam;

    @ApiModelProperty(value = "商品资源:图片or视频及其他")
    @NotEmpty(message = "图片不能为空")
    private List<GoodsResourcesVO> resourcesList;

    @ApiModelProperty(value = "规格")
    @NotEmpty(message = "规格不能为空", groups = {Update.class, Create.class})
    private List<SpecAttrVO> specAttrList;

    @ApiModelProperty(value = "价格库存排列组合表信息")
    private List<LeasePriceStockVO> priceStock;

    @ApiModelProperty(value = "商品详情 富文本")
    private String productDetails;

    @ApiModelProperty(value = "最短租期")
    private Integer minLeaseTerm;

    @ApiModelProperty(value = "最长租期")
    private Integer maxLeaseTerm;

    @ApiModelProperty(value = "配件清单")
    private List<LeasePartsListVO> leasePartsList;

    @ApiModelProperty(value = "发货地址")
    private Integer shipAddress;

    @ApiModelProperty(value = "归还地址")
    private Integer returnAddress;

    @ApiModelProperty(value = "寄出物流")
    private Integer logisticsCompany;

    @ApiModelProperty(value = "配送方式")
    private Integer modeOfDelivery;

    @ApiModelProperty(value = "创建时间 用作列表回显", hidden = true)
    private Date createTime;

    @ApiModelProperty(value = "店铺id 小程序用", hidden = true)
    private Integer userAccountId;
}
