package com.mmc.pms.controller.inspection;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.model.inspection.vo.InspectionVO;
import com.mmc.pms.service.inspection.InspectionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author: zj
 * @Date: 2023/8/4 15:32
 */
@Api(tags = {"服务"})
@RestController
@RequestMapping("/inspection/")
public class InspectionController {
    @Autowired
    private InspectionService inspectionService;

    @ApiOperation(value = "新增服务")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("insert")
    public ResultBody insert(@RequestBody InspectionVO inspectionVO){
        return inspectionService.insert(inspectionVO);
    }

    @ApiOperation(value = "修改服务")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("update")
    public ResultBody update(@RequestBody InspectionVO inspectionVO){
        return inspectionService.update(inspectionVO);
    }

    @ApiOperation(value = "删除服务")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("remove")
    public ResultBody remove(@RequestParam Integer id){
        return inspectionService.remove(id);
    }
}
