package com.mmc.pms.dao;

import com.mmc.pms.entity.*;
import com.mmc.pms.model.qo.IndustrySkuQO;
import com.mmc.pms.model.sale.dto.IndustrySpecCPQVO;
import com.mmc.pms.model.sale.vo.IndustrySkuVO;
import com.mmc.pms.model.sale.vo.IndustrySpecVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 * @Author LW
 *
 * @date 2022/10/8 10:58 概要：
 */
@Mapper
public interface IndustrySpecDao {
  int countSkuName(IndustrySkuVO param);

  int insertIndustrySku(IndustrySku industrySku);

  int countIndustrySkuById(Integer id);

  IndustrySku getIndustrySkuById(Integer id);

  int updateIndustrySku(IndustrySku industrySku);

  int countListPageIndustrySku(IndustrySkuQO param);

  List<IndustrySku> listPageIndustrySku(IndustrySkuQO param);

  int countSpecName(IndustrySpecVO param);

  int insertIndustrySpec(IndustrySpecDO industrySpecDO);

  void insertIndustryProductInventory(IndustryProductInventoryDO industryProductInventoryDO);

  void insertInventorySpec(InventorySpecDO inventorySpecDO);

  int countIndustrySpec(Integer industrySpecId);

  IndustrySpecDO getIndustrySpecById(Integer industrySpecId);

  List<IndustryProductInventoryDO> getIndustryProductInventory(Integer industrySpecId);

  int updateIndustrySpec(IndustrySpecDO industrySpecDO);

  void batchDeleteInventorySpec(List<Integer> industryProductInventoryIds);

  void deleteIndustryProductInventory(Integer id);

  int countListPageIndustrySpec(Integer id, String keyword);

  List<IndustrySpecDO> listPageIndustrySpec(
      int pageNo, Integer pageSize, Integer industrySkuId, String keyword);

  int batchInsertSpecPrice(List<IndustrySpecPriceDO> list);

  void removeIndustrySpecCPQ(IndustrySpecCPQVO industrySpecCPQQ);

  void batchInsertLeaseSpecPrice(List<IndustrySpecPriceDO> list);

  List<IndustrySpecPriceDO> getIndustrySpecCPQ(IndustrySpecCPQVO industrySpecCPQQ);

  void batchUpdateMallIndustrySpec(@Param("list") List<Integer> list, @Param("id") Integer id);

  void batchUpdateMallIndustrySku(@Param("list") List<Integer> list);

  void batchUpdateMallIndustrySkuInfo(List<MallIndustrySkuInfoDO> mallIndustrySkuInfoList);

  List<MallIndustrySkuInfoSpecDO> listMallIndustrySpecInfo(List<Integer> mallSkuIds);

  void batchUpdateMallIndustSpec(@Param("list") List<Integer> list, @Param("id") Integer id);

  List<IndustryProductInventoryDO> listIndustryProdInventory(
      @Param("inventoryIds") Set<Integer> inventoryIds);

  List<IndustrySpecDO> listIndustrySpec(@Param("industrySpecIds") Set<Integer> industrySpecIds);

  int countIndustrySpecBySkuId(Integer id);

  void removeIndustrySku(Integer id);

  List<MallIndustrySkuInfoSpecDO> listMallIndustrySpec(Integer id);

  void removeIndustryProductInventory(List<Integer> collect);

  List<InventorySpecDO> listInventorySpec(List<Integer> ids);

  void removeInventorySpec(List<Integer> ids);

  void removeIndustrySpec(Integer id);

  List<MallIndustrySkuInfoSpecDO> getIndustrySkuInfoSpec(Integer goodsInfoId);

  List<IndustrySpecPriceDO> listIndustrySpecPrice(Integer tagInfoId, List<Integer> industrySpecIds);

  List<IndustrySpecPriceDO> getIndustrySpecPriceList(List<Integer> specIds);
}
