package com.mmc.pms.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;

/**
 * @Author small @Date 2023/5/15 18:03 @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
// @ApiModel(value = "com.mmc.pms.model.vo.LeaseVo", description = "立即租赁")
public class LeaseVo {
  private static final long serialVersionUID = -8917940296555539559L;

  @ApiModelProperty(value = "设备id")
  private Integer id;

  @ApiModelProperty(value = "租期天数开始")
  private Integer startDay;

  @ApiModelProperty(value = "租期天数结束")
  private Integer endDay;

  @ApiModelProperty(value = "库存使用")
  @NotBlank
  private Integer inventoryUsage;

  @ApiModelProperty(value = "库存id")
  private Integer inventoryId;
}
