package com.mmc.pms.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @Author small @Date 2023/5/16 13:35 @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
// @ApiModel(value = "com.mmc.csf.model.vo.GoodsGroupVO", description = "商品分类")
public class GoodsGroupVO implements Serializable {
  @ApiModelProperty(value = "id")
  @NotNull(
      message = "id不能为空",
      groups = {Update.class})
  private Integer id;

  @ApiModelProperty(value = "分类类型id")
  @NotNull(
      message = "分类类型id不能为空",
      groups = {Update.class, Create.class})
  private Integer sortTypeId;

  @ApiModelProperty(value = "分类名称", required = true)
  @Size(
      max = 15,
      message = "分类名称不能超过15个字",
      groups = {Update.class, Create.class})
  @NotNull(
      message = "分类名称不能为空",
      groups = {Update.class, Create.class})
  private String groupName;

  @ApiModelProperty(value = "pid:一级分类的pid是0 二级分类pid是一级分类id", required = true)
  @NotNull(
      message = "pid不能为空",
      groups = {Create.class, Update.class})
  private Integer pid;

  @ApiModelProperty(value = "描述")
  @Size(
      max = 70,
      message = "分类描述不能超过70个字",
      groups = {Update.class, Create.class})
  private String description;

  @ApiModelProperty(value = "icon图标")
  private String icon;

  @ApiModelProperty(value = "小程序底部备注")
  @Size(
      max = 150,
      message = "小程序底部备注不能超过150个字",
      groups = {Update.class, Create.class})
  private String remark;
}
