package com.mmc.pms.model.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author small @Date 2023/5/16 15:55 @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
// @ApiModel(value = "com.mmc.csf.mall.dto.AppGoodsInfoDTO", description = "小程序商品信息DTO")
public class AppGoodsInfoDTO implements Serializable {

  private static final long serialVersionUID = 6104334488561632747L;

  @ApiModelProperty("商品id")
  private Integer id;

  @ApiModelProperty("商品名称")
  private String goodsName;

  @ApiModelProperty("商品上架状态")
  private Integer shelfStatus;

  @ApiModelProperty("商品主图")
  private String mainImg;

  @ApiModelProperty("商品描述")
  private String goodsDesc;

  @ApiModelProperty("商品属性")
  private Integer goodsAttr;

  @ApiModelProperty("生态标签")
  private String ecoLabel;

  @ApiModelProperty("安全编码")
  private String code;

  @ApiModelProperty("排序")
  private Integer sort;

  @ApiModelProperty("安全编码是否显示 0 否 1 是")
  private Integer showCode;
}
