package com.mmc.pms.entity;

import com.mmc.pms.model.dto.MallProductSpecDTO;
import com.mmc.pms.model.dto.ProductSpecDTO;
import com.mmc.pms.model.dto.ProductSpecVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small @Date 2023/5/16 15:30 @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class ProductSpecDO implements Serializable {
  private static final long serialVersionUID = -5476701567447257133L;
  private Integer id;
  private Integer productSkuId;
  private String specName;
  private String specImage;
  private String partNo;
  private String versionDesc;
  private Date createTime;
  private Date updateTime;
  private Integer deleted;

  public ProductSpecDO(ProductSpecVO param) {
    this.id = param.getId();
    this.productSkuId = param.getProductSkuId();
    this.specName = param.getSpecName();
    this.specImage = param.getSpecImage();
    this.partNo = param.getPartNo();
    this.versionDesc = param.getVersionDesc();
  }

  public ProductSpecDTO buildProductSpecDTO() {
    return ProductSpecDTO.builder()
        .id(this.id)
        .productSkuId(this.productSkuId)
        .specName(this.specName)
        .specImage(this.specImage)
        .partNo(this.partNo)
        .versionDesc(this.versionDesc)
        .createTime(this.createTime)
        .build();
  }

  public MallProductSpecDTO buildMallProductSpecDTO() {
    return MallProductSpecDTO.builder()
        .productSpec(this.id)
        .productSkuId(this.productSkuId)
        .specName(this.specName)
        .specImage(this.specImage)
        .partNo(this.partNo)
        .versionDesc(this.versionDesc)
        .build();
  }
}
