package com.mmc.pms.entity;

import com.mmc.pms.model.dto.GoodsQaDTO;
import com.mmc.pms.model.vo.GoodsQaVO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small @Date 2023/5/16 15:23 @Version 1.0
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Builder
public class GoodsQaDO implements Serializable {
  private Integer id;
  private Integer goodsInfoId;
  private String question;
  private String answer;
  private Integer deleted;
  private Date updateTime;
  private Date createTime;

  public GoodsQaDO(GoodsQaVO goodsQaVO) {
    this.question = goodsQaVO.getQuestion();
    this.answer = goodsQaVO.getAnswer();
  }

  public GoodsQaDTO buildGoodsQaDTO() {
    return GoodsQaDTO.builder().id(this.id).answer(this.answer).question(this.question).build();
  }
}
